/*
   Author: Don Capps (capps@iozone.org)
             7417 Crenshaw
            Plano, TX 75025

   The MIT License (MIT)

   Copyright (c) 2015 Don Capps

   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to deal
   in the Software without restriction, including without limitation the rights
   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   THE SOFTWARE.

*/


#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#define NUM_POS 256
long long count[NUM_POS];
int cret;
char filename[254];
FILE *fd;
extern int argc;
extern char **argv;
extern char *optarg;
long long total;

int
main(int argc, char **argv)
{
	int i;
	unsigned long long min,max;
	unsigned char buf;

        while((cret = getopt(argc,argv,"i: ")) != EOF){
                switch(cret){
		case 'i': strcpy(filename,optarg);
			break;
		}
	}
	fd = fopen(filename,"r");
	while(1)
	{
	      if(fread(&buf,1,1,fd) > 0)
	      {
		count[buf]++;
		total++;
	      }
	      else
	      {
		fclose(fd);
		break;
	      }
  	}
	min = total;
	max = 0;
	for(i=0;i<NUM_POS;i++)
	{
	   if(count[i] < min)
		min = count[i];
	   if(count[i] > max)
		max = count[i];
	
	   printf("Count %7lld of character %3d Percent %7.3f\n",count[i],i,
		(float)(count[i]*100)/(float)total);
	}
	printf("Min percent %7.3f \n",(float)(min*100)/(float)total);
	printf("Max percent %7.3f \n",(float)(max*100)/(float)total);
	return(0);
}
	
